<?php
require_once __DIR__ . "/_helpers.php";

function handle_list_post(int $appId, string $file, callable $sanitize_item): array {
  $items = panel_read_json($appId, $file, []);
  if (!is_array($items)) $items = [];

  if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $action = $_POST["action"] ?? "";
    if ($action === "add") {
      $new = $sanitize_item($_POST);
      if ($new) $items[] = $new;
      panel_write_json($appId, $file, $items);
    }
    if ($action === "delete") {
      $idx = intval($_POST["idx"] ?? -1);
      if ($idx >= 0 && $idx < count($items)) {
        array_splice($items, $idx, 1);
        panel_write_json($appId, $file, $items);
      }
    }
    if ($action === "update") {
      $idx = intval($_POST["idx"] ?? -1);
      if ($idx >= 0 && $idx < count($items)) {
        $items[$idx] = $sanitize_item($_POST);
        panel_write_json($appId, $file, $items);
      }
    }
    $items = panel_read_json($appId, $file, []);
    if (!is_array($items)) $items = [];
  }
  return $items;
}
?>