<?php
require_once __DIR__ . "/auth.php";
require_login();
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();
$appName = panel_find_app_name($appId);
$apps = panel_apps_list();
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= isset($pageTitle) ? h($pageTitle) : "Panel" ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #0b0f19; color: #e8eefc; }
    .sidebar { width: 280px; background: rgba(255,255,255,0.04); border-right: 1px solid rgba(255,255,255,0.08); }
    .glass { background: rgba(255,255,255,0.06); border: 1px solid rgba(255,255,255,0.10); border-radius: 16px; }
    .nav-link { color: #cdd8ff; }
    .nav-link.active, .nav-link:hover { color: #fff; background: rgba(245,162,0,0.12); }
    .brand { color:#f5a200; font-weight:700; letter-spacing:.4px;}
    .muted { color: rgba(232,238,252,.7); }
    .table-dark { --bs-table-bg: rgba(255,255,255,0.03); --bs-table-border-color: rgba(255,255,255,0.08); }
    .form-control, .form-select { background: rgba(0,0,0,0.2); border-color: rgba(255,255,255,0.15); color: #e8eefc; }
    .form-control:focus, .form-select:focus { border-color: rgba(245,162,0,0.6); box-shadow: 0 0 0 .25rem rgba(245,162,0,.12); }
    .badge-app { background: rgba(245,162,0,0.18); border: 1px solid rgba(245,162,0,0.35); }
    .mini { font-size: 12px; }
  </style>
</head>
<body>
<div class="d-flex">
  <aside class="sidebar min-vh-100 p-3">
    <div class="d-flex align-items-center justify-content-between mb-3">
      <div>
        <div class="brand">Panel MultiApp</div>
        <div class="muted mini">App activa: <span class="badge badge-app rounded-pill px-2 py-1"><?= h($appName) ?> (#<?= h($appId) ?>)</span></div>
      </div>
      <a class="btn btn-sm btn-outline-light" href="/panel/logout.php">Salir</a>
    </div>

    <form method="post" action="/panel/switch_app.php" class="mb-3">
      <label class="form-label mini">Cambiar App (APP_ID)</label>
      <div class="d-flex gap-2">
        <select class="form-select" name="appId">
          <?php foreach ($apps as $a):
            $id = intval($a["appId"] ?? 0);
            $nm = strval($a["name"] ?? ("App ".$id));
          ?>
            <option value="<?= $id ?>" <?= $id===$appId?'selected':'' ?>><?= h($nm) ?> (<?= h($id) ?>)</option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-warning">OK</button>
      </div>
      <div class="muted mini mt-1">Para agregar más apps, edita <code>/panel/apps.json</code>.</div>
    </form>

    <nav class="nav nav-pills flex-column gap-1">
      <a class="nav-link <?= ($active ?? '')==='dashboard'?'active':'' ?>" href="/panel/index.php">Dashboard</a>
      <a class="nav-link <?= ($active ?? '')==='config'?'active':'' ?>" href="/panel/configuracion.php">Configuración</a>
      <a class="nav-link <?= ($active ?? '')==='slides'?'active':'' ?>" href="/panel/slides.php">Carrusel</a>
      <a class="nav-link <?= ($active ?? '')==='videos'?'active':'' ?>" href="/panel/videos.php">Videos (YouTube)</a>
      <a class="nav-link <?= ($active ?? '')==='photos'?'active':'' ?>" href="/panel/fotos.php">Fotos</a>
      <a class="nav-link <?= ($active ?? '')==='podcasts'?'active':'' ?>" href="/panel/podcasts.php">Podcasts (MP3)</a>
<hr class="border-secondary my-2"/>
      <a class="nav-link" href="/panel/api/app/config.php?appId=<?= h($appId) ?>" target="_blank">Ver API config</a>
      <a class="nav-link" href="/panel/api/app/home.php?appId=<?= h($appId) ?>" target="_blank">Ver API home</a>
    </nav>
  </aside>
  <main class="flex-grow-1 p-4">
