<?php
header("Content-Type: application/json");
require_once __DIR__ . "/_api_helpers.php";
$appId = api_app_id();

$cfg = panel_read_json($appId, "config.json", null);
if ($cfg === null) {
  echo json_encode(["error" => "config not found"], JSON_PRETTY_PRINT);
  exit;
}

echo json_encode([
  "appId" => $appId,
  "branding" => [
    "appName" => $cfg["name"] ?? panel_find_app_name($appId),
    "logoUrl" => $cfg["logo"] ?? "",
    "splashUrl" => $cfg["splash"] ?? "",
    "splashBg" => $cfg["splashBg"] ?? "#000000"
  ],
  "social" => [
    "whatsapp" => $cfg["whatsapp"] ?? "",
    "facebook" => $cfg["facebook"] ?? "",
    "instagram" => $cfg["instagram"] ?? "",
    "tiktok" => $cfg["tiktok"] ?? ""
  ]
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
