<?php
header("Content-Type: application/json; charset=utf-8");
require_once __DIR__ . "/_api_helpers.php";

$appId = api_app_id();

// Slides / hero carousel
$items = panel_read_json($appId, "slides.json", []);
if (!is_array($items)) $items = [];

// Read config
$cfg = panel_read_json($appId, "config.json", []);
if (!is_array($cfg)) $cfg = [];

// ----- COMPAT: branding can be nested OR flat -----
$branding = is_array($cfg["branding"] ?? null) ? $cfg["branding"] : [];

$appName   = $branding["appName"]   ?? ($cfg["name"]  ?? panel_find_app_name($appId));
$logoUrl   = $branding["logoUrl"]   ?? ($cfg["logo"]  ?? "");
$splashUrl = $branding["splashUrl"] ?? ($cfg["splash"] ?? "");
$splashBg  = $branding["splashBg"]  ?? ($cfg["splashBg"] ?? "#000000");

// ----- COMPAT: social can be nested OR flat -----
$socialCfg = is_array($cfg["social"] ?? null) ? $cfg["social"] : [];

$social = [
  "whatsapp"  => $socialCfg["whatsapp"]  ?? ($cfg["whatsapp"]  ?? ""),
  "facebook"  => $socialCfg["facebook"]  ?? ($cfg["facebook"]  ?? ""),
  "instagram" => $socialCfg["instagram"] ?? ($cfg["instagram"] ?? ""),
  "tiktok"    => $socialCfg["tiktok"]    ?? ($cfg["tiktok"]    ?? ""),
];

// Build links[]
$links = [];
foreach ($social as $k => $v) {
  $u = trim((string)$v);
  if ($u === "") continue;

  // Normalize WhatsApp common inputs
  if ($k === "whatsapp") {
    $u = preg_replace('/\s+/', '', $u);
    $u = str_replace("http://+", "+", $u);
    if (preg_match('/^\+?\d{8,15}$/', $u)) {
      $u = preg_replace('/^\+/', '', $u);
      $u = "https://wa.me/" . $u;
    }
  }

  $links[] = ["type" => $k, "url" => $u];
}

// Podcasts
$podcasts = panel_read_json($appId, "podcasts.json", []);
if (!is_array($podcasts)) $podcasts = [];

$podcastOut = [];
foreach ($podcasts as $p) {
  if (!is_array($p)) continue;

  $mp3 = trim((string)($p["mp3Url"] ?? $p["url"] ?? $p["mp3"] ?? ""));
  if ($mp3 === "") continue;

  $podcastOut[] = [
    "title"    => (string)($p["title"] ?? "Podcast"),
    "mp3Url"   => $mp3,
    "coverUrl" => (string)($p["coverUrl"] ?? $p["imageUrl"] ?? $p["cover"] ?? ""),
    "date"     => (string)($p["date"] ?? ""),
    "desc"     => (string)($p["desc"] ?? $p["description"] ?? ""),
  ];
}
if (count($podcastOut) > 0) {
  $links[] = ["type" => "podcasts", "url" => "internal://podcasts"];
}

// Photos (optional, if your panel saves photos.json)
$photos = panel_read_json($appId, "photos.json", []);
if (!is_array($photos)) $photos = [];

$photoOut = [];
foreach ($photos as $ph) {
  if (!is_array($ph)) continue;
  $img = trim((string)($ph["imageUrl"] ?? $ph["url"] ?? $ph["image"] ?? ""));
  if ($img === "") continue;
  $photoOut[] = ["imageUrl" => $img];
}
if (count($photoOut) > 0) {
  $links[] = ["type" => "photos", "url" => "internal://photos"];
}

// Videos (optional, if your panel saves videos.json)
$videos = panel_read_json($appId, "videos.json", []);
if (!is_array($videos)) $videos = [];

$videoOut = [];
foreach ($videos as $v) {
  if (!is_array($v)) continue;

  $title = trim((string)($v["title"] ?? "Video"));
  $ytUrl = trim((string)($v["youtubeUrl"] ?? ""));
  $ytId  = trim((string)($v["youtubeId"] ?? ""));

  if ($ytUrl === "" && $ytId !== "") {
    $ytUrl = "https://www.youtube.com/watch?v=" . $ytId;
  }
  if ($ytUrl === "") continue;

  $videoOut[] = ["title" => $title, "youtubeUrl" => $ytUrl];
}
if (count($videoOut) > 0) {
  $links[] = ["type" => "videos", "url" => "internal://videos"];
}

echo json_encode([
  "heroCarousel" => $items,
  "branding" => [
    "appName"   => $appName,
    "logoUrl"   => $logoUrl,
    "splashUrl" => $splashUrl,
    "splashBg"  => $splashBg,
  ],
  "social"   => $social,
  "links"    => $links,
  "podcasts" => $podcastOut,
  "photos"   => $photoOut,
  "videos"   => $videoOut,
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);





