<?php
$pageTitle = "Configuración";
$active = "config";
require_once __DIR__ . "/_layout_top.php";
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();

$cfg = panel_read_json($appId, "config.json", [
  "name" => panel_find_app_name($appId),
  "logo" => panel_base_url()."/logo.png",
  // Splash de la app (imagen opcional). Recomendado 1080x1920 (9:16)
  "splash" => "",
  // Color de fondo del splash (hex), por si la app lo usa
  "splashBg" => "#000000",
  "whatsapp" => "",
  "facebook" => "",
  "instagram" => "",
  "tiktok" => ""
]);

$ok = false;
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $cfg["name"] = trim($_POST["name"] ?? "");
  $cfg["splashBg"] = trim($_POST["splashBg"] ?? ($cfg["splashBg"] ?? "#000000"));
  $cfg["whatsapp"] = trim($_POST["whatsapp"] ?? "");
  $cfg["facebook"] = trim($_POST["facebook"] ?? "");
  $cfg["instagram"] = trim($_POST["instagram"] ?? "");
  $cfg["tiktok"] = trim($_POST["tiktok"] ?? "");

  // Logo upload or URL
  $logoUrl = panel_save_uploaded_image($appId, "logoFile");
  if ($logoUrl) {
    $cfg["logo"] = $logoUrl;
  } else {
    $cfg["logo"] = trim($_POST["logo"] ?? "");
  }

  // Splash upload (prefer 9:16). If not uploaded, allow URL.
  $splashUrl = panel_save_uploaded_vertical_image($appId, "splashFile", 1080, 1920);
  if ($splashUrl) {
    $cfg["splash"] = $splashUrl;
  } else {
    $cfg["splash"] = trim($_POST["splash"] ?? ($cfg["splash"] ?? ""));
  }

  $ok = panel_write_json($appId, "config.json", $cfg);
}
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-1">Configuración</h3>
    <div class="muted">Nombre, logo, splash (subida directa) y redes sociales.</div>
  </div>
</div>

<?php if ($ok): ?>
  <div class="alert alert-success">Guardado ✅</div>
<?php endif; ?>

<div class="glass p-3">
  <form method="post" enctype="multipart/form-data">
    <div class="row g-3">
      <div class="col-12 col-lg-6">
        <label class="form-label">Nombre de la app</label>
        <input class="form-control" name="name" value="<?= h($cfg["name"]) ?>" required>
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Logo (subir imagen)</label>
        <input class="form-control" type="file" name="logoFile" accept="image/*">
        <div class="muted mini mt-1">Si no subes, usa URL abajo.</div>
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">URL del logo (opcional)</label>
        <input class="form-control" name="logo" value="<?= h($cfg["logo"]) ?>" placeholder="https://...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Splash (subir imagen)</label>
        <input class="form-control" type="file" name="splashFile" accept="image/*">
        <div class="muted mini mt-1">Recomendado 1080x1920 (vertical 9:16). Si no subes, usa URL abajo.</div>
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">URL del splash (opcional)</label>
        <input class="form-control" name="splash" value="<?= h($cfg["splash"] ?? "") ?>" placeholder="https://...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Color de fondo splash (hex)</label>
        <input class="form-control" name="splashBg" value="<?= h($cfg["splashBg"] ?? "#000000") ?>" placeholder="#000000">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">WhatsApp (link)</label>
        <input class="form-control" name="whatsapp" value="<?= h($cfg["whatsapp"]) ?>" placeholder="https://wa.me/...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Facebook (link)</label>
        <input class="form-control" name="facebook" value="<?= h($cfg["facebook"]) ?>" placeholder="https://facebook.com/...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Instagram (link)</label>
        <input class="form-control" name="instagram" value="<?= h($cfg["instagram"]) ?>" placeholder="https://instagram.com/...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">TikTok (link)</label>
        <input class="form-control" name="tiktok" value="<?= h($cfg["tiktok"]) ?>" placeholder="https://tiktok.com/...">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Vista previa logo</label><br/>
        <img src="<?= h($cfg["logo"]) ?>" style="max-height:72px;border-radius:12px;border:1px solid rgba(255,255,255,.12)">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Vista previa splash</label><br/>
        <?php if (!empty($cfg["splash"])): ?>
          <img src="<?= h($cfg["splash"]) ?>" style="max-height:140px;border-radius:12px;border:1px solid rgba(255,255,255,.12)">
        <?php else: ?>
          <div class="muted mini">(sin splash)</div>
        <?php endif; ?>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-warning">Guardar</button>
      <a class="btn btn-outline-light" target="_blank" href="/panel/api/app/config.php?appId=<?= h($appId) ?>">Ver API</a>
    </div>
  </form>
</div>

<?php require_once __DIR__ . "/_layout_bottom.php"; ?>
