<?php
$pageTitle = "Dashboard";
$active = "dashboard";
require_once __DIR__ . "/_layout_top.php";
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();

$config = panel_read_json($appId, "config.json", []);
$slides = panel_read_json($appId, "slides.json", []);
$videos = panel_read_json($appId, "videos.json", []);
$photos = panel_read_json($appId, "photos.json", []);
$events = panel_read_json($appId, "events.json", []);

$counts = [
  "Carrusel" => is_array($slides)?count($slides):0,
  "Videos" => is_array($videos)?count($videos):0,
  "Fotos" => is_array($photos)?count($photos):0,
  "Eventos" => is_array($events)?count($events):0,
];

$appName = $config["name"] ?? panel_find_app_name($appId);

$labels = [];
$values = [];
for ($i=5; $i>=0; $i--) {
  $labels[] = date("M", strtotime("-$i month"));
  $values[] = rand(10, 60);
}
?>
<div class="mb-3">
  <h2 class="mb-1"><?= h($appName) ?></h2>
  <div class="muted">Dashboard con métricas genéricas (por AppId).</div>
</div>

<div class="row g-3 mb-3">
  <?php foreach ($counts as $k=>$v): ?>
    <div class="col-12 col-md-6 col-xl-3">
      <div class="glass p-3">
        <div class="muted small"><?= h($k) ?></div>
        <div class="display-6 mb-0"><?= h($v) ?></div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-7">
    <div class="glass p-3">
      <div class="fw-semibold">Actividad (genérica)</div>
      <div class="muted small mb-2">Ejemplo de gráfica mensual</div>
      <canvas id="chart1" height="120"></canvas>
    </div>
  </div>
  <div class="col-12 col-lg-5">
    <div class="glass p-3">
      <div class="fw-semibold mb-2">Distribución de contenido</div>
      <canvas id="chart2" height="140"></canvas>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
  new Chart(document.getElementById('chart1'), {
    type: 'line',
    data: {
      labels: <?= json_encode($labels) ?>,
      datasets: [{
        label: 'Interacciones',
        data: <?= json_encode($values) ?>,
        tension: 0.35,
        fill: true
      }]
    },
    options: {
      plugins: { legend: { labels: { color: '#cdd8ff' } } },
      scales: {
        x: { ticks: { color: '#cdd8ff' }, grid: { color: 'rgba(255,255,255,.08)' } },
        y: { ticks: { color: '#cdd8ff' }, grid: { color: 'rgba(255,255,255,.08)' } }
      }
    }
  });

  new Chart(document.getElementById('chart2'), {
    type: 'doughnut',
    data: {
      labels: <?= json_encode(array_keys($counts)) ?>,
      datasets: [{ data: <?= json_encode(array_values($counts)) ?> }]
    },
    options: { plugins: { legend: { labels: { color: '#cdd8ff' } } } }
  });
</script>

<?php require_once __DIR__ . "/_layout_bottom.php"; ?>
