<?php
$pageTitle = "Podcasts";
$active = "podcasts";
require_once __DIR__ . "/_layout_top.php";
require_once __DIR__ . "/_crud_list.php";
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();

$items = handle_list_post($appId, "podcasts.json", function($p) use ($appId){
  $title = trim($p["title"] ?? "");
  if ($title === "") return null;

  // MP3: upload first
  $mp3Uploaded = panel_save_uploaded_mp3($appId, "mp3File");
  $mp3Url = $mp3Uploaded ?: trim($p["mp3Url"] ?? "");
  if ($mp3Url === "" || !preg_match('/\.mp3(\?.*)?$/i', $mp3Url)) return null;

  // Cover (vertical)
  $coverUploaded = panel_save_uploaded_vertical_image($appId, "coverFile");
  $coverUrl = $coverUploaded ?: trim($p["coverUrl"] ?? "");
  if ($coverUrl === "") $coverUrl = panel_base_url()."/logo.png";

  $desc = trim($p["description"] ?? "");

  return [
    "title" => $title,
    "description" => $desc,
    "mp3Url" => $mp3Url,
    "coverUrl" => $coverUrl
  ];
});
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-1">Podcasts (MP3)</h3>
    <div class="muted">Solo se aceptan archivos <b>.mp3</b>. Portadas en vertical (9:16).</div>
  </div>
  <a target="_blank" class="btn btn-sm btn-outline-light" href="/panel/api/app/podcasts.php?appId=<?= h($appId) ?>">Ver API podcasts</a>
</div>

<div class="glass p-3 mb-3">
  <form method="post" class="row g-2 align-items-end" enctype="multipart/form-data">
    <input type="hidden" name="action" value="add">
    <div class="col-12 col-lg-4">
      <label class="form-label">Título</label>
      <input class="form-control" name="title" placeholder="Ej: Episodio 1" required>
    </div>
    <div class="col-12 col-lg-4">
      <label class="form-label">MP3 (subir)</label>
      <input class="form-control" type="file" name="mp3File" accept="audio/mpeg,.mp3">
    </div>
    <div class="col-12 col-lg-4">
      <label class="form-label">…o URL MP3</label>
      <input class="form-control" name="mp3Url" placeholder="https://.../archivo.mp3">
    </div>
    <div class="col-12 col-lg-6">
      <label class="form-label">Portada (vertical)</label>
      <input class="form-control" type="file" name="coverFile" accept="image/*">
    </div>
    <div class="col-12 col-lg-6">
      <label class="form-label">…o URL portada</label>
      <input class="form-control" name="coverUrl" placeholder="https://...">
    </div>
    <div class="col-12">
      <label class="form-label">Descripción (opcional)</label>
      <textarea class="form-control" name="description" rows="2" placeholder="Descripción corta"></textarea>
    </div>
    <div class="col-12 col-lg-2 ms-auto">
      <button class="btn btn-primary w-100">Agregar</button>
    </div>
  </form>
</div>

<div class="glass p-0 overflow-hidden">
  <div class="table-responsive">
    <table class="table table-dark table-hover align-middle mb-0">
      <thead><tr>
        <th style="width:70px">#</th>
        <th>Podcast</th>
        <th class="text-end" style="width:300px">Acciones</th>
      </tr></thead>
      <tbody>
      <?php foreach($items as $i => $it):
        $title = $it["title"] ?? "";
        $desc = $it["description"] ?? "";
        $mp3 = $it["mp3Url"] ?? "";
        $cover = $it["coverUrl"] ?? "";
      ?>
        <tr>
          <td><?= $i ?></td>
          <td>
            <div class="d-flex align-items-start gap-3">
              <?php if ($cover): ?>
                <img src="<?= h($cover) ?>" style="width:90px;height:160px;object-fit:cover;border-radius:10px;border:1px solid rgba(255,255,255,.15);" />
              <?php endif; ?>
              <div>
                <div class="fw-semibold"><?= h($title) ?></div>
                <?php if ($desc): ?><div class="small muted"><?= h($desc) ?></div><?php endif; ?>
                <?php if ($mp3): ?><div class="small">MP3: <a target="_blank" href="<?= h($mp3) ?>"><?= h($mp3) ?></a></div><?php endif; ?>
              </div>
            </div>

            <details class="mt-2">
              <summary class="btn btn-sm btn-outline-light">Editar</summary>
              <div class="mt-2 p-2 border border-secondary rounded">
                <form method="post" class="row g-2 align-items-end" enctype="multipart/form-data">
                  <input type="hidden" name="action" value="update">
                  <input type="hidden" name="idx" value="<?= $i ?>">
                  <div class="col-12 col-lg-4">
                    <label class="form-label">Título</label>
                    <input class="form-control" name="title" value="<?= h($title) ?>" required>
                  </div>
                  <div class="col-12 col-lg-4">
                    <label class="form-label">MP3 (subir)</label>
                    <input class="form-control" type="file" name="mp3File" accept="audio/mpeg,.mp3">
                  </div>
                  <div class="col-12 col-lg-4">
                    <label class="form-label">…o URL MP3</label>
                    <input class="form-control" name="mp3Url" value="<?= h($mp3) ?>">
                  </div>
                  <div class="col-12 col-lg-6">
                    <label class="form-label">Portada (vertical)</label>
                    <input class="form-control" type="file" name="coverFile" accept="image/*">
                  </div>
                  <div class="col-12 col-lg-6">
                    <label class="form-label">…o URL portada</label>
                    <input class="form-control" name="coverUrl" value="<?= h($cover) ?>">
                  </div>
                  <div class="col-12">
                    <label class="form-label">Descripción</label>
                    <textarea class="form-control" name="description" rows="2"><?= h($desc) ?></textarea>
                  </div>
                  <div class="col-12 col-lg-2 ms-auto">
                    <button class="btn btn-warning w-100">Guardar</button>
                  </div>
                </form>
                <div class="small muted mt-2">Si subes un MP3 nuevo, reemplaza la URL. Si no subes, se mantiene.</div>
              </div>
            </details>
          </td>
          <td class="text-end">
            <form method="post" style="display:inline">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="idx" value="<?= $i ?>">
              <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Eliminar podcast?')">Eliminar</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!count($items)): ?>
        <tr><td colspan="3" class="text-center muted p-4">Sin podcasts todavía.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . "/_layout_bottom.php"; ?>
