<?php
$pageTitle = "Carrusel";
$active = "slides";
require_once __DIR__ . "/_layout_top.php";
require_once __DIR__ . "/_crud_list.php";
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();

$items = handle_list_post($appId, "slides.json", function($p) use ($appId){
  // Vertical 9:16 image
  $uploaded = panel_save_uploaded_vertical_image($appId, "imageFile");
  if ($uploaded) return ["imageUrl" => $uploaded];

  $url = trim($p["imageUrl"] ?? "");
  if ($url === "") return null;
  return ["imageUrl" => $url];
});
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-1">Carrusel</h3>
    <div class="muted">Imágenes verticales (9:16). Al subir, el panel las recorta a 1080x1920.</div>
  </div>
  <a target="_blank" class="btn btn-sm btn-outline-light" href="/panel/api/app/home.php?appId=<?= h($appId) ?>">Ver API home</a>
</div>

<div class="glass p-3 mb-3">
  <form method="post" class="row g-2 align-items-end" enctype="multipart/form-data">
    <input type="hidden" name="action" value="add">
    <div class="col-12 col-lg-6">
      <label class="form-label">Subir imagen (recomendado)</label>
      <input class="form-control" type="file" name="imageFile" accept="image/*">
    </div>
    <div class="col-12 col-lg-4">
      <label class="form-label">…o URL</label>
      <input class="form-control" name="imageUrl" placeholder="https://...">
    </div>
    <div class="col-12 col-lg-2">
      <button class="btn btn-primary w-100">Agregar</button>
    </div>
  </form>
</div>

<div class="glass p-0 overflow-hidden">
  <div class="table-responsive">
    <table class="table table-dark table-hover align-middle mb-0">
      <thead><tr>
        <th style="width:70px">#</th>
        <th>Preview</th>
        <th class="text-end" style="width:260px">Acciones</th>
      </tr></thead>
      <tbody>
      <?php foreach($items as $i => $it): $url = $it["imageUrl"] ?? ""; ?>
        <tr>
          <td><?= $i ?></td>
          <td>
            <?php if ($url): ?>
              <div class="d-flex align-items-center gap-3">
                <img src="<?= h($url) ?>" style="width:90px;height:160px;object-fit:cover;border-radius:10px;border:1px solid rgba(255,255,255,.15);" />
                <div class="small muted text-break"><?= h($url) ?></div>
              </div>
            <?php endif; ?>
            <details class="mt-2">
              <summary class="btn btn-sm btn-outline-light">Editar</summary>
              <div class="mt-2 p-2 border border-secondary rounded">
                <form method="post" class="row g-2 align-items-end" enctype="multipart/form-data">
                  <input type="hidden" name="action" value="update">
                  <input type="hidden" name="idx" value="<?= $i ?>">
                  <div class="col-12 col-lg-6">
                    <label class="form-label">Nueva imagen (vertical)</label>
                    <input class="form-control" type="file" name="imageFile" accept="image/*">
                  </div>
                  <div class="col-12 col-lg-4">
                    <label class="form-label">…o URL</label>
                    <input class="form-control" name="imageUrl" value="<?= h($url) ?>">
                  </div>
                  <div class="col-12 col-lg-2">
                    <button class="btn btn-warning w-100">Guardar</button>
                  </div>
                </form>
              </div>
            </details>
          </td>
          <td class="text-end">
            <form method="post" style="display:inline">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="idx" value="<?= $i ?>">
              <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Eliminar slide?')">Eliminar</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!count($items)): ?>
        <tr><td colspan="3" class="text-center muted p-4">Sin imágenes todavía.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . "/_layout_bottom.php"; ?>
