<?php
$pageTitle = "Videos";
$active = "videos";
require_once __DIR__ . "/_layout_top.php";
require_once __DIR__ . "/_crud_list.php";
require_once __DIR__ . "/_helpers.php";
$appId = panel_current_app_id();

$items = handle_list_post($appId, "videos.json", function($p){
  $input = trim($p["youtube"] ?? "");
  $id = panel_extract_youtube_id($input);
  if ($id === "") return null;

  $meta = panel_youtube_metadata($id);
  $title = $meta["title"] ?? "";
  $thumb = $meta["thumbnail"] ?? "";

  // Always derive title + cover from YouTube metadata (oEmbed)
  return ["youtubeId" => $id, "title" => $title, "imageUrl" => $thumb];
});
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-1">Videos (YouTube)</h3>
    <div class="muted">Pega link o ID. El panel guarda automáticamente el <b>título</b> y la <b>portada</b> desde el metadato del video.</div>
  </div>
  <a target="_blank" class="btn btn-sm btn-outline-light" href="/panel/api/app/videos.php?appId=<?= h($appId) ?>">Ver API videos</a>
</div>

<div class="glass p-3 mb-3">
  <form method="post" class="row g-2 align-items-end">
    <input type="hidden" name="action" value="add">
    <div class="col-12 col-lg-9">
      <label class="form-label">YouTube (URL o ID)</label>
      <input class="form-control" name="youtube" placeholder="https://youtu.be/XXXXXXXXXXX  ó  XXXXXXXXXXX" required>
    </div>
    <div class="col-12 col-lg-3">
      <button class="btn btn-primary w-100">Agregar</button>
    </div>
  </form>
</div>

<div class="glass p-0 overflow-hidden">
  <div class="table-responsive">
    <table class="table table-dark table-hover align-middle mb-0">
      <thead><tr>
        <th style="width:70px">#</th>
        <th>Video</th>
        <th class="text-end" style="width:300px">Acciones</th>
      </tr></thead>
      <tbody>
      <?php foreach($items as $i => $it): 
        $yid = $it["youtubeId"] ?? "";
        $title = $it["title"] ?? "";
        $img = $it["imageUrl"] ?? "";
      ?>
        <tr>
          <td><?= $i ?></td>
          <td>
            <div class="d-flex align-items-center gap-3">
              <?php if ($img): ?>
                <img src="<?= h($img) ?>" style="width:120px;height:68px;object-fit:cover;border-radius:10px;border:1px solid rgba(255,255,255,.15);" />
              <?php endif; ?>
              <div>
                <div class="fw-semibold"><?= h($title) ?></div>
                <div class="small muted">ID: <code><?= h($yid) ?></code>
                  <?php if ($yid): ?> · <a target="_blank" href="https://www.youtube.com/watch?v=<?= h($yid) ?>">Abrir</a><?php endif; ?>
                </div>
              </div>
            </div>

            <details class="mt-2">
              <summary class="btn btn-sm btn-outline-light">Editar</summary>
              <div class="mt-2 p-2 border border-secondary rounded">
                <form method="post" class="row g-2 align-items-end">
                  <input type="hidden" name="action" value="update">
                  <input type="hidden" name="idx" value="<?= $i ?>">
                  <div class="col-12 col-lg-9">
                    <label class="form-label">Nuevo YouTube (URL o ID)</label>
                    <input class="form-control" name="youtube" value="<?= h($yid) ?>" required>
                  </div>
                  <div class="col-12 col-lg-3">
                    <button class="btn btn-warning w-100">Guardar</button>
                  </div>
                </form>
                <div class="small muted mt-2">Al guardar, el panel vuelve a leer el metadato (título + portada).</div>
              </div>
            </details>
          </td>
          <td class="text-end">
            <form method="post" style="display:inline">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="idx" value="<?= $i ?>">
              <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Eliminar video?')">Eliminar</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!count($items)): ?>
        <tr><td colspan="3" class="text-center muted p-4">Sin videos todavía.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . "/_layout_bottom.php"; ?>
